//	CMassApplication.cpp

#include "CMassApplication.h"

CMassApplication *cMass;												//	global instance of our application
long thoughtPriority;													//	hack for setting priority

char *soundNames[N_SOUNDS] = {"Da Winner", "Player 1 Boom", "Player 2 Boom"};

CMassApplication::CMassApplication()
		  		  : BApplication("application/x-critical-mass")
{
	BRect			aRect;
	long i;																//	loop index
	BRect theRect;														//	for setting the size of pictures
	app_info CMAppInfo;													//	used for finding where the application is
	BEntry CMEntry;														//	entry in database representing the app
	BFile CMFile;														//	the CMass application file
	BResources CMResources;												//	the CMass resources
	status_t errorCode;													//	used for checking success
	char *aSound;														//	a sound loaded
	size_t soundLength;													//	length of the sound in bytes
	CMassWindow *theCMWindow;											//	the window we create
	
	// set up a rectangle and instantiate a new window
	aRect.Set(100, 100, 483, 470);
	theCMWindow = new CMassWindow(aRect);
	
	// make window visible
	theCMWindow->Show();
		
	//	find the file in the database
	GetAppInfo(&CMAppInfo);												//	ask our global app to tell us where it is
	errorCode = CMEntry.SetTo(&CMAppInfo.ref);							//	convert this to a database entry
	if (errorCode != B_NO_ERROR)										//	if that didn't work
		FatalErrorAlert(DIE_BAD_ENTRY);									//	die gracefully
	errorCode = CMFile.SetTo(&CMEntry, B_READ_ONLY);					//	open it in read-only mode
	if (errorCode != B_NO_ERROR)										//	if that didn't work
		FatalErrorAlert(DIE_BAD_FILE);									//	die gracefully
	errorCode = CMResources.SetTo(&CMFile);								//	open the resources
	if (errorCode != B_NO_ERROR)										//	if that didn't work
		FatalErrorAlert(DIE_BAD_RESOURCES);								//	die gracefully
	for (i = 0; i < N_SOUNDS; i++)										//	walk through, reading in sounds
		{
		aSound = (char *) CMResources.FindResource(B_RAW_TYPE, i+1000, &soundLength);	//	retrieve the sound
		if (aSound != NULL)												//	i.e. it was successful
			{
			theSounds[i] = new CMSound(soundNames[i], aSound, soundLength);
																		//	create the sound
//			theSounds[i]->Play();										//	play it, just to be sure
			} // end of aSound != NULL
		else															//	oops, it doesn't exist
			cMass->FatalErrorAlert(DIE_BAD_SOUND);						//	die gracefully
		} // end of for i = 0 to N_SOUNDS

	
} // end of CMassApplication()

void CMassApplication::FatalErrorAlert(char *message)	//	sets up an alert, then dies
	{
	BAlert *moribund;			// declare an alert
		
	moribund = new BAlert("Critical Mass Suicide Note", message, "OK.  Go ahead and die!", NULL, NULL, 
							B_WIDTH_FROM_LABEL,B_STOP_ALERT);
								//	set the alert up
	moribund->Go();				//	run it & wait for it to return
	Quit();	
	}

